#ifndef _FT_PLATFORM_H_
#define _FT_PLATFORM_H_

#define ARDUINO_PLATFORM
//#define ARDUNIO_PRO_328
#define FT_ARDUINO_ATMEGA328P

//#define MSVC_PLATFORM
//#define SAMAPP_DISPLAY_QVGA
#define SAMAPP_DISPLAY_WQVGA

#ifdef  ARDUINO_PLATFORM

#define ARDUINO_PLATFORM_SPI
#define ARDUINO_PLATFORM_COCMD_BURST

/* Arduino Pro Specific definitions */
#ifdef ARDUNIO_PRO_328
#define FT_ARDUINO_PRO_SPI_CS (10)
#define FT_SDCARD_CS (5)       // Which pin is sdcard enable connected to?
#define FT800_INT (6)
#define FT800_PD_N (4)
#endif
 
/* ft800 plus board ATMEGA328P definitions */
#ifdef FT_ARDUINO_ATMEGA328P
#define FT_ARDUINO_PRO_SPI_CS (10) /* FT800 chip select */
#define FT_SDCARD_CS (8) /* sdcard or flash chip select */
#define FT800_INT (3) /* FT800 interrupt pin */
#define FT800_PD_N (4) /* FT800 power down pin */
#endif

#endif

#ifdef ARDUINO_PLATFORM
#include <stdio.h>
#include <Arduino.h>
#include <EEPROM.h>
#include <SPI.h>
#include <avr/pgmspace.h>
#endif

#ifdef MSVC_PLATFORM
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <Windows.h>

#include "ftd2xx.h"
#include "LibMPSSE_spi.h"
#endif


#include "FT_DataTypes.h"
#include "FT_Gpu_Hal.h"
#include "FT_Gpu.h"
#include "FT_CoPro_Cmds.h"



#ifdef MSVC_PLATFORM
#define BUFFER_OPTIMIZATION
#define MSVC_PLATFORM_SPI
/* Compile time switch for enabling sample app api sets - please cross check the same in SampleApp_RawData.cpp file as well */

#define SAMAPP_ENABLE_APIS_SET0
#define SAMAPP_ENABLE_APIS_SET1
#define SAMAPP_ENABLE_APIS_SET2
#define SAMAPP_ENABLE_APIS_SET3
#define SAMAPP_ENABLE_APIS_SET4
#endif

#ifdef ARDUINO_PLATFORM
/* Compile time switch for enabling sample app api sets - please cross check the same in SampleApp_RawData.cpp file as well */
/*
#define SAMAPP_ENABLE_APIS_SET0
#define SAMAPP_ENABLE_APIS_SET1
#define SAMAPP_ENABLE_APIS_SET2
#define SAMAPP_ENABLE_APIS_SET3

*/
#define SAMAPP_ENABLE_ROTARY_DEMO
//#define SAMAPP_ENABLE_APIS_SET1

#endif
#endif /*_FT_PLATFORM_H_*/
/* Nothing beyond this*/




